/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.ar;

import com.ibm.hwmca.base.pa.ar.DistributedDataEventAnalysisRoutine;
import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.PIDumpEvent;
import com.ibm.hwmca.p.pa.event.PelDataEvent;
import com.ibm.hwmca.p.pa.event.SaelDataEvent;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.event.DistributedDataEvent;

public class PIDDEAnalysisRoutine
extends DistributedDataEventAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPAPIDAT";
    private static final String TRACE_MASKF = "PPAPIDAF";
    private static final String TRACE_MASKD = "PPAPIDAD";
    private static final String OS_400 = "OS400";

    public PIDDEAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> analyze()");
        if (event instanceof PelDataEvent) {
            Trace.trace(TRACE_MASKD, "pelEvent.toString() = " + ((PelDataEvent)event).toString());
        }
        if (this.piAnalyze(event)) {
            this.reportIncident((CommonDataEvent)event, this.anIncident, this.eventDomain.getInitialTimeoutEvent(this), this.eventDomain.getInitialWait());
        }
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }

    protected boolean piAnalyze(ProblemAnalysisEvent event) {
        DistributedDataEvent dde = (DistributedDataEvent)event;
        if (dde.isSurveillanceError()) {
            Trace.trace(TRACE_MASKD, "Surveillance error discarded");
            return false;
        }
        super.analyze(dde);
        if (this.eventDomain == null) {
            Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String dataString = "couldn't find domain: " + dde.getDomainId().getDID();
            theLog.add((byte)3, dataString);
            theLog.log();
            return false;
        }
        if (!this.eventDomain.isPrimary()) {
            Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String dataString = "not primary for domain: " + dde.getDomainId().getDID();
            theLog.add((byte)3, dataString);
            theLog.log();
            return false;
        }
        PIProblem ourProblem = (PIProblem)this.anIncident.getProblem();
        if (ourProblem == null) {
            Log theLog = new Log(-86, 70, 0, "PA EVT DSCRD", null, null, null, null);
            String dataString = "couldn't create problem";
            theLog.add((byte)3, dataString);
            theLog.log();
            return false;
        }
        String refCode = dde.getRefcode();
        ourProblem.setRefcode(refCode);
        if (refCode.length() < 8 || refCode.indexOf("-") != -1) {
            ourProblem.setSymptomString("9100 SRN" + refCode);
        } else {
            ourProblem.setSymptomString("9100 SRC" + refCode);
        }
        ourProblem.setFirstReportedTimestamp(dde.getFirstReportedTime());
        ourProblem.setLastReportedTimestamp(dde.getFirstReportedTime());
        ourProblem.setFailingSystem(dde.getFailingEnclosureSystem());
        ourProblem.setServiceableEventText(dde.getSvcEventText());
        ourProblem.setEventSeverity(dde.getEventSeverity());
        ourProblem.addAssociatedCECSystem(dde.getAssociatedSystemList());
        LocalizableText notificationText = dde.getNotificationType();
        if (notificationText != null) {
            ourProblem.setNotificationType(notificationText);
            ourProblem.setNotifyCustomer(notificationText.toString().equals(new LocalizableText("Service Action (customer notification) Required").toString()) || notificationText.toString().equals(new LocalizableText("Call Home Required").toString()));
            ourProblem.setCallHome(notificationText.toString().equals(new LocalizableText("Call Home Required").toString()));
        }
        ourProblem.setServiceableEventCreationTimestamp(System.currentTimeMillis());
        ourProblem.setPlatformLogID(dde.getPlatformLogID());
        ourProblem.setSubsystemID(dde.getSubsystemID());
        ourProblem.setHMCLocale(dde.getHMCLocales());
        ourProblem.setNlsMessages(dde.getNLSMessages());
        ourProblem.addParts(dde.getFruList());
        StringBuffer myOutSB = new StringBuffer();
        XMLHelper.outToXML(ourProblem, myOutSB, ourProblem.getClass());
        Trace.trace(TRACE_MASKD, "PIProblem.outToXML to show what we have added so far (common info)" + myOutSB);
        if (dde instanceof PelDataEvent) {
            PelDataEvent pde = (PelDataEvent)dde;
            if (pde.containsDump()) {
                PIDumpEvent dumpEvt = new PIDumpEvent(this);
                dumpEvt.setData(pde);
                dumpEvt.setIncident(this.anIncident);
                this.anIncident.setSecondaryEvent(dumpEvt);
            }
        } else if (dde instanceof SaelDataEvent) {
            SaelDataEvent sde = (SaelDataEvent)dde;
            ourProblem.setPartitionID(sde.getPartitionID());
            ourProblem.setPartitionName(sde.getPartitionName());
            ourProblem.setPartitionHostName(sde.getPartitionHostName());
            ourProblem.setPartitionOSType(sde.getPartitionOSType());
            ourProblem.setClusterSystem(sde.getClusterSystem());
            ourProblem.setSwitchNetworkID(sde.getHPSNetworkID());
            ourProblem.setErrorLogLabelID(sde.getErrorLogLabel());
            ourProblem.setEED(sde.getEED());
            ourProblem.setSequenceNumber(sde.getSeqNum());
            if (sde.getPartitionOSType() != null && sde.getPartitionOSType().equals(OS_400)) {
                Trace.trace(TRACE_MASKD, "OS_400 sael set systemLogId with errorLogLabel " + sde.getErrorLogLabel());
                ourProblem.setSystemLogID(sde.getErrorLogLabel());
            } else {
                Trace.trace(TRACE_MASKD, "non OS/400 sael set systemLogId with getSystemLogId " + sde.getSystemLogId());
                ourProblem.setSystemLogID(sde.getSystemLogId());
            }
            ourProblem.setSymptomString(sde.getSymptomString());
            ourProblem.setFirstReportedTimestamp(sde.timeStringToLong(sde.getSaelFirstReportedTime()));
            ourProblem.setLastReportedTimestamp(sde.timeStringToLong(sde.getLastSubsystemReportedTime()));
            ourProblem.setCallHome(sde.getCalledHome() != 1L);
        }
        return true;
    }
}

